<?php
/* -----------------------------------------------------------------------------------------
   $Id: payone_wlt.php 15761 2024-02-29 18:59:48Z GTB $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
 	 based on:
	  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
	  (c) 2002-2003 osCommerce - www.oscommerce.com
	  (c) 2001-2003 TheMedia, Dipl.-Ing Thomas Plänkers - http://www.themedia.at & http://www.oscommerce.at
	  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com
    (c) 2013 Gambio GmbH - http://www.gambio.de
  
   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

require_once (DIR_FS_EXTERNAL.'payone/classes/PayonePayment.php');

class payone_wlt extends PayonePayment {

	var $payone_genre = 'ewallet';

  var $code;
  var $form_action_url;

  var $payone;
  var $personal_data;
  var $delivery_data;
  var $payment_method;
  var $params;
  var $builder;

	function __construct() {
		$this->code = 'payone_wlt';
		parent::__construct();
		$this->form_action_url = '';
	}

  function update_status() {
    parent::update_status();
    
    if ($this->enabled === true) {
      $genre_config = $this->config[$this->_getActiveGenreIdentifier()];		
      
      foreach ($genre_config['types'] as $key => $value) {
        if ($genre_config['types'][$key]['active'] != 'true'
            && $genre_config['types'][$key]['name'] == 'paymenttype_paypal'
            ) 
        {
          $this->enabled = false;
        }
      }
    }
  }

	function selection() {
		$selection = parent::selection();

		return $selection;
	}

	function confirmation() {
		$active_genre = $this->_getActiveGenreIdentifier();
		$confirmation = array(
			'title' => constant('MODULE_PAYMENT_'.strtoupper($this->code).'_TEXT_TITLE'),
		);
		return $confirmation;
	}

	function payment_action() {
	  global $order, $insert_id;
    
    if (!isset($insert_id) || $insert_id == '') {
		  $insert_id = $_SESSION['tmp_oID'];
		}

		$this->payone->log("(pre-)authorizing $this->code payment");
		$standard_parameters = parent::_standard_parameters();

		$this->personal_data = new Payone_Api_Request_Parameter_Authorization_PersonalData();
		parent::_set_customers_standard_params();

		$this->delivery_data = new Payone_Api_Request_Parameter_Authorization_DeliveryData();
		parent::_set_customers_shipping_params();

		$this->payment_method = new Payone_Api_Request_Parameter_Authorization_PaymentMethod_Wallet();
		$this->payment_method->setWallettype('PPE');
		$this->payment_method->setSuccessurl(((ENABLE_SSL == true) ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG.FILENAME_CHECKOUT_PROCESS.'?'.xtc_session_name().'='.xtc_session_id());
		$this->payment_method->setBackurl(((ENABLE_SSL == true) ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?'.xtc_session_name().'='.xtc_session_id());
		$this->payment_method->setErrorurl(((ENABLE_SSL == true) ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG.FILENAME_CHECKOUT_PAYMENT.'?'.xtc_session_name().'='.xtc_session_id().'&payment_error='.$this->code);

    // set order_id for deleting canceld order
    $_SESSION['tmp_payone_oID'] = $_SESSION['tmp_oID'];
		
    $request_parameters = parent::_request_parameters('wlt');

		$this->params = array_merge($standard_parameters, $request_parameters);
		$this->builder = new Payone_Builder($this->payone->getPayoneConfig());
    
    parent::_build_service_authentification('wlt');
    parent::_parse_response_payone_api();

		xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL'));
	}

	function after_process() {
		parent::after_process();
	}
}
