<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_date_long.inc.php 15820 2024-04-12 11:41:08Z GTB $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com
   (c) 2003	nextcommerce (xtc_date_long.inc.php,v 1.3 2003/08/13); www.nextcommerce.org
   (c) 2006 XT-Commerce

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

  // Output a raw date string in the selected locale date format
  // $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS
  function xtc_date_long($raw_date) {
    if(defined('USE_SHORT_DATE_FORMAT') && USE_SHORT_DATE_FORMAT == 'true') {
      if(!function_exists('xtc_date_short')) {
        require_once(DIR_FS_INC.'xtc_date_short.inc.php');
      }
      return xtc_date_short($raw_date);
    }

    if ($raw_date == '0000-00-00 00:00:00' 
        || empty($raw_date) 
        )
    {
      return false;
    }
    
    if (function_exists('datefmt_create')) {
      $dateTime = date_create($raw_date, timezone_open(DEFAULT_TIMEZONE));
      $formatter = datefmt_create(DATE_LOCALE, IntlDateFormatter::LONG, IntlDateFormatter::SHORT);
      $date = datefmt_format($formatter, $dateTime);
    } else {
      $year = (int)substr($raw_date, 0, 4);
      $month = (int)substr($raw_date, 5, 2);
      $day = (int)substr($raw_date, 8, 2);
      $hour = (int)substr($raw_date, 11, 2);
      $minute = (int)substr($raw_date, 14, 2);
      $second = (int)substr($raw_date, 17, 2);

      $date = date(DATE_FORMAT_LONG, mktime($hour,$minute,$second,$month,$day,$year));
    }
    
    return decode_utf8($date);
  }
