<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_collect_posts.inc.php 16480 2025-06-17 11:24:07Z GTB $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce coding standards; www.oscommerce.com
   (c) 2006 XT-Commerce (xtc_db_perform.inc.php 899 2005-04-29)

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c) Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

  function xtc_collect_posts() {
    global $xtPrice, $cc_id, $messageStack, $PHP_SELF;

    if (isset($_POST['gv_redeem_code']) && xtc_not_null($_POST['gv_redeem_code'])) {
      unset($_SESSION['cc_id']);
      
      $gv_query = xtc_db_query("SELECT *
                                  FROM " . TABLE_COUPONS . "
                                 WHERE coupon_code = '".xtc_db_input(trim($_POST['gv_redeem_code']))."'
                                   AND coupon_active = 'Y'");
      $gv_result = xtc_db_fetch_array($gv_query);

      if (xtc_db_num_rows($gv_query) != 0) {
        $redeem_query = xtc_db_query("SELECT * 
                                        FROM " . TABLE_COUPON_REDEEM_TRACK . " 
                                       WHERE coupon_id = '" . $gv_result['coupon_id'] . "'");
        if ((xtc_db_num_rows($redeem_query) != 0) && ($gv_result['coupon_type'] == 'G')) {
          $messageStack->add_session('coupon_message', ERROR_NO_INVALID_REDEEM_GV);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
      } else {
        $messageStack->add_session('coupon_message', ERROR_NO_INVALID_REDEEM_GV);
        xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
      }

      // GIFT CODE G START
      if ($gv_result['coupon_type'] == 'G') {
        
        // check if customer is guest
        if ($_SESSION['customers_status']['customers_status_id'] != DEFAULT_CUSTOMERS_STATUS_ID_GUEST) {                         
          $gv_amount = $gv_result['coupon_amount'];
          
          // check gv for customer
          $gv_amount_query = xtc_db_query("SELECT amount 
                                             FROM " . TABLE_COUPON_GV_CUSTOMER . " 
                                            WHERE customer_id = '" . (int)$_SESSION['customer_id'] . "'");
          $customer_gv = false;
          $total_gv_amount = $gv_amount;
          if ($gv_amount_result = xtc_db_fetch_array($gv_amount_query)) {
            $total_gv_amount = $gv_amount_result['amount'] + $gv_amount;
            $customer_gv = true;
          }
          $gv_update = xtc_db_query("UPDATE " . TABLE_COUPONS . " 
                                        SET coupon_active = 'N' 
                                      WHERE coupon_id = '" . $gv_result['coupon_id'] . "'");
        
          $sql_data_array = array(
             'coupon_id' => $gv_result['coupon_id'], 
             'redeem_date' => 'now()',  
             'redeem_ip' => (isset($_SESSION['tracking']['ip']) ? xtc_db_prepare_input($_SESSION['tracking']['ip']) : ''),  
             'customer_id' => (int)$_SESSION['customer_id']  
          );
          xtc_db_perform(TABLE_COUPON_REDEEM_TRACK, $sql_data_array);
          
          if ($customer_gv === true) {
            // already has gv_amount so update
            $gv_update = xtc_db_query("UPDATE " . TABLE_COUPON_GV_CUSTOMER . " 
                                          SET amount = '" . $total_gv_amount . "' 
                                        WHERE customer_id = '" . (int)$_SESSION['customer_id'] . "'");
          } else {
            // no gv_amount so insert
            $sql_data_array = array(
               'customer_id' => (int)$_SESSION['customer_id'],
               'amount' => $total_gv_amount               
            );
            xtc_db_perform(TABLE_COUPON_GV_CUSTOMER, $sql_data_array);
          }
          $messageStack->add_session('coupon_message', sprintf(REDEEMED_AMOUNT, $xtPrice->xtcFormatCurrency($gv_amount)), 'success');
          
          if (strpos(basename($PHP_SELF), 'checkout') !== false) {
            $_SESSION['cot_gv'] = 'ot_gv';
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'NONSSL'));
          } else {
            xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'));
          }
        } else {
          $messageStack->add_session('coupon_message', GUEST_REDEEM_NOT_ALLOWED);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
      } else {

        if (xtc_db_num_rows($gv_query)==0) {
          $messageStack->add_session('coupon_message', ERROR_NO_INVALID_REDEEM_COUPON);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
        
        // not active yet
        if (strtotime($gv_result['coupon_start_date']) > time()) {
          $messageStack->add_session('coupon_message', ERROR_INVALID_STARTDATE_COUPON);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
        
        // expired
        if (strtotime($gv_result['coupon_expire_date']) < time()) {
          $messageStack->add_session('coupon_message', ERROR_INVALID_FINISDATE_COUPON);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }

        // restrict to customers
        if (!empty($gv_result['restrict_to_customers'])) {
          $customers_status_array = explode(',', $gv_result['restrict_to_customers']);
          if (!in_array($_SESSION['customers_status']['customers_status_id'], $customers_status_array)) {
            $messageStack->add_session('coupon_message', ERROR_INVALID_CUSTOMERS_STATUS_COUPON);
            xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
          }
        }
        
        // min order
        $coupon_minimum_order = $xtPrice->xtcCalculateCurr($gv_result['coupon_minimum_order']);
        if ($coupon_minimum_order > $_SESSION['cart']->show_total()) {
          $messageStack->add_session('coupon_message', sprintf(ERROR_INVALID_MINIMUM_ORDER_COUPON, $xtPrice->xtcFormat($coupon_minimum_order, true, 0, true)));
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
        
        // limit to uses
        $coupon_count = xtc_db_query("SELECT coupon_id 
                                        FROM " . TABLE_COUPON_REDEEM_TRACK . " 
                                       WHERE coupon_id = '" . $gv_result['coupon_id']."'");
        $coupon_count_customer = xtc_db_query("SELECT * 
                                                 FROM " . TABLE_COUPON_REDEEM_TRACK . "  crt
                                                 JOIN " . TABLE_ORDERS . " o
                                                      ON o.orders_id = crt.order_id
                                                         AND o.customers_email_address = '" . xtc_db_input($_SESSION['customer_email_address']) . "'
                                                WHERE crt.coupon_id = '" . $gv_result['coupon_id'] . "'");
        if (xtc_db_num_rows($coupon_count)>=$gv_result['uses_per_coupon'] && $gv_result['uses_per_coupon'] > 0) {
          $messageStack->add_session('coupon_message', ERROR_INVALID_USES_COUPON . $gv_result['uses_per_coupon'] . TIMES);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
        if (xtc_db_num_rows($coupon_count_customer) >= $gv_result['uses_per_user'] && $gv_result['uses_per_user'] > 0) {
          $messageStack->add_session('coupon_message', ERROR_INVALID_USES_USER_COUPON . $gv_result['uses_per_user'] . TIMES);
          xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
        }
        
        $messageStack->add_session('coupon_message', REDEEMED_COUPON, 'success');
        
        if ($gv_result['coupon_type'] == 'S') {
          $messageStack->add_session('coupon_message', TEXT_COUPON_HELP_FREESHIP, 'success');
        } else {
          $messageStack->add_session('coupon_message', sprintf(TEXT_COUPON_HELP_FIXED, $xtPrice->xtcFormat($gv_result['coupon_amount'], true, 0, true)), 'success');
        }
        if ($gv_result['coupon_type'] == 'P') {
          $messageStack->add_session('coupon_message', sprintf(TEXT_COUPON_HELP_FIXED, round($gv_result['coupon_amount'],0)) . '%', 'success');
        }
        if ($gv_result['coupon_minimum_order'] > 0) {          
          $messageStack->add_session('coupon_message', sprintf(TEXT_COUPON_HELP_MINORDER, $xtPrice->xtcFormat($gv_result['coupon_minimum_order'], true, 0, true)), 'success');
        }
        if ($gv_result['coupon_specials'] == 0) {
          $messageStack->add_session('coupon_message', TEXT_COUPON_HELP_SPECIALS, 'success');
        }        
        if ($gv_result['restrict_to_products'] != '') {
          $messageStack->add_session('coupon_message', TEXT_COUPON_PRODUCTS_RESTRICT, 'success');
        }
        if ($gv_result['restrict_to_categories'] != '') {
          $messageStack->add_session('coupon_message', TEXT_COUPON_CATEGORIES_RESTRICT, 'success');
        }
        if ($gv_result['restrict_to_manufacturers'] != '') {
          $messageStack->add_session('coupon_message', TEXT_COUPON_MANUFACTURERS_RESTRICT, 'success');
        }
        
        $_SESSION['cc_amount_min_order'] = $coupon_minimum_order;
        $_SESSION['cc_id'] = $gv_result['coupon_id'];
        $_SESSION['cc_post'] = true;
        
        xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
      }
    }
        
    if (isset($_POST['gv_redeem_code']) && (isset($_POST['check_gift']) || isset($_POST['check_gift_x']))) {
      $messageStack->add_session('coupon_message', ERROR_NO_REDEEM_CODE);
      xtc_redirect(xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')), 'NONSSL'));
    }
  }
