<?php
/** 
 * -----------------------------------------------------------------------------------------
 * PDFBill NEXT by Robert Hoppe
 * Copyright 2011 Robert Hoppe - xtcm@katado.com - http://www.katado.com
 *
 * Please visit http://pdfnext.katado.com for newer Versions
 * -----------------------------------------------------------------------------------------
 *  
 * Released under the GNU General Public License 
 * 
 */
require('includes/application_top.php');
define('FPDF_FONTPATH', DIR_FS_CATALOG . DIR_WS_CLASSES . 'FPDF/font/');

// include needed classes
require_once(DIR_WS_CLASSES . 'order.php');
//require_once(DIR_FS_CATALOG . 'includes/external/phpmailer/class.phpmailer.php'); // PHPMailer is beeing provided through xtc_php_mail.inc.php, see line 22
require_once(DIR_FS_CATALOG . DIR_WS_CLASSES . 'FPDF/PdfRechnung.php');

// include needed functions
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_pdf_bill.inc.php');

require_once(DIR_FS_INC . 'xtc_get_order_data.inc.php');
require_once(DIR_FS_INC . 'xtc_get_attributes_model.inc.php');
require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_utf8_decode.inc.php');

// check for oID
if (!isset($_GET['oID'])) {
    die('Something went wrong! No oID was given!');
} else {
    $oID = xtc_db_input($_GET['oID']);
}

// Send PDF to customer if requested
if (isset($_GET['send'])) {
    // generate bill and send to customer
    xtc_pdf_bill($oID, true, true);

// without Mail - just generate
} else { 
    xtc_pdf_bill($oID, false, true);
}

// replace Variables for filePrefix
$sqlODetail = "
SELECT 
    customers_id,
    customers_cid,
    ibn_billnr
FROM  " . TABLE_ORDERS . "
WHERE orders_id = '" . $oID . "'
";
$resODetail = xtc_db_query($sqlODetail);
$rowODetail = xtc_db_fetch_array($resODetail);

// use customers_id as the real id?
if (PDF_USE_CUSTOMER_ID == 'true') {
    $customers_id = $rowODetail['customers_id'];
} else {
    $customers_id = $rowODetail['customers_cid'];
}

// ibn_billnr if exists
$order_bill = $rowODetail['ibn_billnr'];

// create FilePrefix
$filePrefix = trim(PDF_FILENAME_SLIP); 
$filePrefix = str_replace('{oID}', $oID, $filePrefix);
$filePrefix = str_replace('{bill}', $order_bill, $filePrefix);
$filePrefix = str_replace('{cID}', $customers_id, $filePrefix);
$filePrefix = str_replace(' ', '_', $filePrefix);
if ($filePrefix == '') $filePrefix = $oID;

  require (DIR_WS_INCLUDES.'head.php');
?>
</head>
<body <?php if (isset($_GET['send'])) echo "onload='window.parent.location.reload();window.parent.iframeBox_close();'"; ?>>
	<table class="tableBody bs4">
		<tr>
			<td class="boxCenter">
				<div class="pageHeadingImage"><?php echo xtc_image(DIR_WS_ICONS.'heading/icon_configuration.png', PDF_PRINT_PACKINGSLIP_PDF_TITLE); ?></div>
				<div class="flt-l">
					<div class="pageHeading pdg2"><?php echo PDF_PRINT_PACKINGSLIP_PDF_TITLE; ?></div>
				</div>
				<div class="admin_container cf clear">
					<table class="clear tableConfig">
						<tr>
							<td class="dataTableConfig col-left"><?php echo PDF_PRINT_PACKINGSLIP_SEND_TEXT; ?></td>
							<td class="dataTableConfig col-middle"><a class="button but_green" href="<?php echo $_SERVER['PHP_SELF']; ?>?oID=<?php echo $_GET['oID']; ?>&send=1"><?php echo PDF_PRINT_PACKINGSLIP_SEND; ?></a></td>
						</tr>
						<tr>
							<td class="dataTableConfig col-left"><?php echo PDF_PRINT_PACKINGSLIP_DL_TEXT; ?></td>
							<td class="dataTableConfig col-middle"><a class="button but_green" href="invoice/<?php echo $filePrefix; ?>.pdf"><?php echo PDF_PRINT_PACKINGSLIP_DL; ?></a></td>
						</tr>
						<tr>
							<td class="txta-l" colspan="3" style="border:none;">
								<input class="button" type="button" value="<?php echo PDF_CLOSE_WINDOW; ?>" onclick="window.parent.iframeBox_close();" />
							</td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
	</table>
</body>
</html>
