<?php
/* -----------------------------------------------------------------------------------------
		$Id: PDFBill_Next.php 4242 2016-01-28 13:29:09Z Ralph_84 $

		Modified - community made shopping
		http://www.modified-shop.org

		Copyright (c) 2009 - 2016 Modified

		Installer PDFBill Next Modified 2.0 r9281
		erstellt von Ralph_84

		Karl1 - Anpassungen an Modified Shopversion 2.0.7.x
		https://www.modified-shop.org/forum/index.php?topic=12939

		-----------------------------------------------------------------------------------------
		Released under the GNU General Public License
		---------------------------------------------------------------------------------------*/

  defined('_VALID_XTC') or die('Direct Access to this location is not allowed.');

  define('MODULE_PDFBILL_Version', '2.0.5');

	if ($_SESSION['language_code'] == 'de')
	{
	  define('MODULE_PDFBILL_TEXT_DESCRIPTION', '<div style="text-align:center">PDFBill Next
						<br /><br /></div>'
						. ((!defined('MODULE_INVOICE_NUMBER_STATUS') || strtolower(MODULE_INVOICE_NUMBER_STATUS) != 'true') ? '<div style="text-align:center;color:red;">
						<strong>Das System Modul "Rechnungsnummern" muss installiert und aktiv sein.<br />Dieses ist zur Funktionalit&#228;t dieses Moduls notwendig!<br /><br /></strong>
						</div>' : '<br />') .
						'<strong>Als zus&#228;tzliche Funktionen sind vorhanden:</strong>
						<ul style="padding-left:20px;">
						  <li>Erweiterung </li>
						  <li>Anzeige innergemeinschaftlicher Warenverkehr f&#252;r PDFBillNext</li>
						</ul>
						<br />');
	  define('MODULE_PDFBILL_TEXT_TITLE', 'PDFBill Next');
	  define('MODULE_PDF_BILL_STATUS_TITLE','Modul Aktiv?');
	  define('MODULE_PDF_BILL_STATUS_DESC','');
	  define('MODULE_PDFBILL_DELETE_BUTTON','Alle Moduldateien l&ouml;schen');
	  define('MODULE_PDFBILL_DELETE_CONFIRM','Sollen alle Moduldateien gel&ouml;scht werden?<br>Hinweis: Das PDF-Verzeichnis <strong>' . DIR_ADMIN  . 'invoice</strong> wird nicht gel&ouml;scht!');
	  define('MODULE_PDFBILL_DELETE_FILES_INFO','Das PDF-Verzeichnis "' . DIR_ADMIN  . '/invoice" wird nicht gel&ouml;scht!');
	  define('MODULE_PDFBILL_DELETE_FILE_ERROR',' - konnte nicht gel&ouml;scht werden!');
	}
	else
	{
	  define('MODULE_PDFBILL_TEXT_DESCRIPTION', '<div style="text-align:center">PDFBill Next
						<br /><br /></div>'
						. ((!defined('MODULE_INVOICE_NUMBER_STATUS') || strtolower(MODULE_INVOICE_NUMBER_STATUS) != 'true') ? '<div style="text-align:center;color:red;">
						<strong>The system module "Invoice numbers" have to be installed.<br />This is needed for the funktion of PDF Bill Next!<br /><br /></strong>
						</div>' : '<br />') .
						'<strong>&nbsp;&nbsp;Extra Funktions:</strong>
						<ul style="padding-left:20px;">
							<li>Extra </li>
							<li>intra-community supply/intra-community delivery</li>
						</ul>
						<br />');
	  define('MODULE_PDFBILL_TEXT_TITLE', 'PDFBill Next');
	  define('MODULE_PDF_BILL_STATUS_TITLE','Modul Activ?');
	  define('MODULE_PDF_BILL_STATUS_DESC','');
	  define('MODULE_PDFBILL_DELETE_BUTTON','Delete all modules files');
	  define('MODULE_PDFBILL_DELETE_CONFIRM','Should all modules files be deleted?<br>Note: The folder <strong>' . DIR_ADMIN  . 'invoice</strong> would not be deleted!');
	  define('MODULE_PDFBILL_DELETE_FILES_INFO','The folder "' . DIR_ADMIN  . '/invoice" would not be deleted!');
	  define('MODULE_PDFBILL_DELETE_FILE_ERROR',' - could not be deleted!');
	}


	class pdfbill {

    var $code;
    var $title;
    var $description;
    var $sort_order;
    var $enabled;
    var $properties;
    var $_check;

    public function __construct() {
			$this->code = 'pdfbill';
			$this->title = MODULE_PDFBILL_TEXT_TITLE . ' - v' . MODULE_PDFBILL_Version;
			$this->description = '';
			if (defined('MODULE_PDF_BILL_STATUS')) $this->description .= '<a class="button btnbox but_green" style="text-align:center;" onclick="this.blur();" href="' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=system&module=' . $this->code . '&action=update') . '">Update</a><br /><br />';
			$this->description .= '<a class="button btnbox but_red" style="text-align:center;" onclick="return confirmLink(\''. MODULE_PDFBILL_DELETE_CONFIRM .'\', \'\' ,this);" href="' . xtc_href_link(FILENAME_MODULE_EXPORT, 'set=system&module=' . $this->code . '&action=custom') . '">' . MODULE_PDFBILL_DELETE_BUTTON . '</a><br />';
			$this->description .= MODULE_PDFBILL_TEXT_DESCRIPTION;
			$this->sort_order = ((defined('MODULE_PDF_BILL_SORT_ORDER')) ? MODULE_PDF_BILL_SORT_ORDER : '');
			$this->enabled = ((defined('MODULE_PDF_BILL_STATUS') && MODULE_PDF_BILL_STATUS == 'true') ? true : false);
			$this->properties = array('process_key' => false);
		}

		public function process($file) {
			// do nothing
		}

		public function display()
		{
			$text = '<br /><div align="center">' . xtc_button(BUTTON_SAVE) .
				xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module='.$this->code) . "</div>");
			return array('text' => $text);
		}

		public function check()
		{
	    if (!isset($this->_check)) {
	      if (defined('MODULE_PDF_BILL_STATUS')) {
	        $this->_check = true;
	      } else {
	        $check_query = xtc_db_query("SELECT configuration_value
	                                      FROM " . TABLE_CONFIGURATION . "
	                                      WHERE configuration_key = 'MODULE_PDF_BILL_STATUS'");
	        $this->_check = xtc_db_num_rows($check_query);
	      }
	    }
	    return $this->_check;
		}

		public function install()
		{
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD bill_nr INT( 1 ) NOT NULL ;");
			xtc_db_query("UPDATE " . TABLE_ADMIN_ACCESS . " SET bill_nr = '1' WHERE customers_id = '1';");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD pdfbill_del INT( 1 ) NOT NULL ;");
			xtc_db_query("UPDATE " . TABLE_ADMIN_ACCESS . " SET pdfbill_del = '1' WHERE customers_id = '1';");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD print_order_pdf INT( 1 ) NOT NULL ;");
			xtc_db_query("UPDATE " . TABLE_ADMIN_ACCESS . " SET print_order_pdf = '1' WHERE customers_id = '1';");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " ADD print_packingslip_pdf INT( 1 ) NOT NULL ;");
			xtc_db_query("UPDATE " . TABLE_ADMIN_ACCESS . " SET print_packingslip_pdf = '1' WHERE customers_id = '1';");
			xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION_GROUP . " (configuration_group_title, configuration_group_description, sort_order) VALUES ('PDFBill Configuration', 'PDFBill Overall Configuration', NULL);");
			// Tabelle configuration
			$this->check_table_config();
	  }

		public function remove()
		{
			$this->remove_table_config();
			xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION_GROUP . " WHERE configuration_group_title = 'PDFBill Configuration'");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP `bill_nr`");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP `pdfbill_del`");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP `print_order_pdf`");
			xtc_db_query("ALTER TABLE " . TABLE_ADMIN_ACCESS . " DROP `print_packingslip_pdf`");
		}

		public function keys()
		{
			return array('MODULE_PDF_BILL_STATUS');
		}


		public function update()
		{
			$this->check_table_config();
      $this->remove_obsolete_files_or_dirs();
		}

		public function custom()
		{
			global $messageStack;

			$messageStack->add_session(MODULE_PDFBILL_DELETE_FILES_INFO, 'success');

			// Systemmodule deinstallieren
			if (defined('MODULE_PDF_BILL_STATUS') && MODULE_PDF_BILL_STATUS == 'true') {
				$this->remove();
			}

			// Dateien definieren
			$shop_path = DIR_FS_CATALOG;
			$dirs_and_files = array();
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'pdfbill_del.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'print_order_pdf.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'print_packingslip_pdf.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/application_top/application_top_end/pdf_bill_check.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/filenames/pdfbill.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/menu/pdfbill.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/menu/pdfbill_del.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/modules/orders/orders_info_blocks_end/pdf_bill_buttons.php';
			$dirs_and_files[] = $shop_path.DIR_ADMIN.'includes/extra/modules/orders/orders_update/pdf_bill_send.php';

			$dirs_and_files[] = $shop_path.'inc/xtc_pdf_bill.inc.php';
			$dirs_and_files[] = $shop_path.'inc/xtc_utf8_decode.inc.php';

			$dirs_and_files[] = $shop_path.'includes/classes/FPDF';
			$dirs_and_files[] = $shop_path.'includes/extra/checkout/checkout_process_end/pdf_bill_send.php';
			$dirs_and_files[] = $shop_path.'includes/extra/send_order/data/pdf_bill_send.php';

			$dirs_and_files[] = $shop_path.'lang/english/admin/pdfbill_del.php';
			$dirs_and_files[] = $shop_path.'lang/english/admin/print_order_pdf.php';
			$dirs_and_files[] = $shop_path.'lang/english/admin/print_packingslip_pdf.php';
			$dirs_and_files[] = $shop_path.'lang/english/extra/admin/buttons.php';
			$dirs_and_files[] = $shop_path.'lang/english/extra/admin/configuration_99.php';
			$dirs_and_files[] = $shop_path.'lang/english/extra/admin/orders.php';
			$dirs_and_files[] = $shop_path.'lang/english/modules/contribution/pdfbill.php';

			$dirs_and_files[] = $shop_path.'lang/german/admin/pdfbill_del.php';
			$dirs_and_files[] = $shop_path.'lang/german/admin/print_order_pdf.php';
			$dirs_and_files[] = $shop_path.'lang/german/admin/print_packingslip_pdf.php';
			$dirs_and_files[] = $shop_path.'lang/german/extra/admin/buttons.php';
			$dirs_and_files[] = $shop_path.'lang/german/extra/admin/configuration_99.php';
			$dirs_and_files[] = $shop_path.'lang/german/extra/admin/orders.php';
			$dirs_and_files[] = $shop_path.'lang/german/modules/contribution/pdfbill.php';

			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/english/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/english/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/english/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/english/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/german/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/german/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/german/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/admin/mail/german/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified/img/logo_invoice.png';

			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/english/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/english/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/english/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/english/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/german/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/german/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/german/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/admin/mail/german/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_nova/img/logo_invoice.png';

			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/english/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/english/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/english/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/english/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/german/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/german/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/german/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/admin/mail/german/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/tpl_modified_responsive/img/logo_invoice.png';


			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/english/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/english/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/english/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/english/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/german/forwarder_mail.html';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/german/forwarder_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/german/invoice_mail.html';
			$dirs_and_files[] = $shop_path.'templates/xtc5/admin/mail/german/invoice_mail.txt';
			$dirs_and_files[] = $shop_path.'templates/xtc5/img/logo_invoice.png';

			// Dateien löschen
			foreach ($dirs_and_files as $dir_or_file) {
				if(!$this->rrmdir($dir_or_file)){
					$messageStack->add_session($dir_or_file . MODULE_PDFBILL_DELETE_FILE_ERROR, 'error');
				}
			}

			// Datei selbst löschen
			unlink($shop_path.DIR_ADMIN.'includes/modules/system/pdfbill.php');
		}

		protected function rrmdir($dir) {
			if (is_dir($dir)) {
				$objects = scandir($dir);
				foreach ($objects as $object) {
					if ($object != "." && $object != "..") {
						if (filetype($dir."/".$object) == "dir") $this->rrmdir($dir."/".$object); else unlink($dir."/".$object);
					}
				}
				reset($objects);
				rmdir($dir);
				return true;
			} elseif(is_file($dir)) {
				unlink($dir);
				return true;
			}
		}

		protected function check_table_config()
		{
			$config = $this->get_config();

			foreach($config as $key => $value) {
				$query = xtc_db_query("SELECT configuration_key FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $key ."'");
				$exist = xtc_db_num_rows($query);
				if ($exist < 1) {
					xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) values " . $value);
				}
				if ($key == 'PDF_STATUS_ID_BILL' || $key == 'PDF_STATUS_ID_SLIP') {
					$query = xtc_db_query("SELECT configuration_key FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $key ."' AND use_function = 'xtc_get_order_status_name'");
					$new = xtc_db_num_rows($query);
					if ($new < 1) {
						if ($key == 'PDF_STATUS_ID_BILL') {
										xtc_db_query("UPDATE ".TABLE_CONFIGURATION."
			                 SET sort_order = '92',
			                     use_function = 'xtc_get_order_status_name',
			                     set_function = 'xtc_cfg_pull_down_order_statuses('
			               WHERE configuration_key = '" . $key ."'");
						}
						if ($key == 'PDF_STATUS_ID_SLIP') {
										xtc_db_query("UPDATE ".TABLE_CONFIGURATION."
			                 SET sort_order = '94',
			                     use_function = 'xtc_get_order_status_name',
			                     set_function = 'xtc_cfg_pull_down_order_statuses('
			               WHERE configuration_key = '" . $key ."'");
						}
					}
				}
				if ($key == 'PDF_MAIL_SLIP_FORWARDER') {
					$query = xtc_db_query("SELECT sort_order FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $key ."' AND use_function = 'xtc_get_order_status_name'");
					$new = xtc_db_fetch_row($query);
					if ($new < 1) {
						xtc_db_query("UPDATE ".TABLE_CONFIGURATION."
							SET sort_order = '222'
							WHERE configuration_key = '" . $key ."'");
					}
				}
				if ($key == 'PDF_STATUS_SEND_ID') {
					$query = xtc_db_query("SELECT sort_order FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $key ."' AND sort_order = '222'");
					$new = xtc_db_fetch_row($query);
					if ($new < 1) {
						xtc_db_query("UPDATE ".TABLE_CONFIGURATION."
							SET use_function = 'xtc_get_order_status_name',
									set_function = 'xtc_cfg_pull_down_order_statuses('
							WHERE configuration_key = '" . $key ."'");
					}
				}
 			}
		}

		protected function remove_table_config()
		{
			$config = $this->get_config();

			foreach($config as $key => $value) {
				xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $key ."'");
			}
		}

		protected function remove_obsolete_files_or_dirs()
		{
			global $messageStack;

			// Dateien definieren
			$shop_path = DIR_FS_CATALOG;
			$dirs_and_files = array();
			$dirs_and_files[] = $shop_path.'includes/functions/invoice_number_functions.php';

			// Dateien löschen
			foreach ($dirs_and_files as $dir_or_file) {
				if (is_dir($dir_or_file) || is_file($dir_or_file)) {
					if(!$this->rrmdir($dir_or_file)){
						$messageStack->add_session($dir_or_file . MODULE_PDFBILL_DELETE_FILE_ERROR, 'error');
					}
				}
			}
		}

		protected function get_config()
		{
			// select configuration_group_id dynamically, noRiddle
			$pdf_gr_id_qu = xtc_db_query("SELECT configuration_group_id FROM ".TABLE_CONFIGURATION_GROUP." WHERE configuration_group_title = 'PDFBill Configuration'");
			if(xtc_db_num_rows($pdf_gr_id_qu)) {
				$pdf_gr_id_arr = xtc_db_fetch_array($pdf_gr_id_qu);
				$gr = (int)$pdf_gr_id_arr['configuration_group_id'];

				// alle Einträge in der Tabelle configuration werden hier definiert
				$config = array();

				$config['MODULE_PDF_BILL_STATUS'] = "('MODULE_PDF_BILL_STATUS', 'true', 6, 0, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_SEND_ORDER'] = "('PDF_SEND_ORDER', 'false', " . $gr . ", 10, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_SEND_SLIP_WITH_ORDER'] = "('PDF_SEND_SLIP_WITH_ORDER', 'false', " . $gr . ", 15, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_SEND_WITH_ORDER_MAIL'] = "('PDF_SEND_WITH_ORDER_MAIL', 'false', " . $gr . ", 20, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_MASTER_PASS'] = "('PDF_MASTER_PASS', 'heresomepass', " . $gr . ", 30, NULL, now(), NULL, NULL)";
				$config['PDF_FILENAME'] = "('PDF_FILENAME', 'SomeBill{oID}', " . $gr . ", 40, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_BILL_COPY'] = "('PDF_MAIL_BILL_COPY', '', " . $gr . ", 50, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_SUBJECT'] = "('PDF_MAIL_SUBJECT', 'Your PDFBill NEXT', " . $gr . ", 60, NULL, now(), NULL, NULL)";
				$config['PDF_USE_ORDERID'] = "('PDF_USE_ORDERID', 'false', " . $gr . ", 70, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_USE_CUSTOMER_ID'] = "('PDF_USE_CUSTOMER_ID', 'false', " . $gr . ", 80, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_UPDATE_STATUS'] = "('PDF_UPDATE_STATUS', 'true', " . $gr . ", 90, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_STATUS_ID_BILL'] = "('PDF_STATUS_ID_BILL', '1', " . $gr . ", 92, NULL, now(), 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(')";
				$config['PDF_STATUS_ID_SLIP'] = "('PDF_STATUS_ID_SLIP', '1', " . $gr . ", 94, NULL, now(), 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(')";
				$config['PDF_USE_ORDERID_SUFFIX'] = "('PDF_USE_ORDERID_SUFFIX', '', " . $gr . ", 100, NULL, now(), NULL, NULL)";
				$config['PDF_STATUS_COMMENT'] = "('PDF_STATUS_COMMENT', 'Rechnung versendet', " . $gr . ", 110, NULL, now(), NULL, NULL)";
				$config['PDF_CUSTOM_TEXT'] = "('PDF_CUSTOM_TEXT', '', " . $gr . ", 120, NULL, now(), NULL, NULL)";
				$config['PDF_PRODUCT_MODEL_LENGTH'] = "('PDF_PRODUCT_MODEL_LENGTH', '7', " . $gr . ", 150, NULL, now(), NULL, NULL)";
				$config['PDF_STATUS_SEND'] = "('PDF_STATUS_SEND', 'false', " . $gr . ", 160, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_STATUS_SEND_ID'] = "('PDF_STATUS_SEND_ID', '1', " . $gr . ", 170, NULL, now(), 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(')";
				$config['PDF_STATUS_SEND_WITH_SLIP'] = "('PDF_STATUS_SEND_WITH_SLIP', 'false', " . $gr . ", 175, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_STATUS_SEND_WITH_SLIP_ID'] = "('PDF_STATUS_SEND_WITH_SLIP_ID', '1', " . $gr . ", 176, NULL, now(), 'xtc_get_order_status_name' , 'xtc_cfg_pull_down_order_statuses(')";
				$config['PDF_STATUS_COMMENT_SLIP'] = "('PDF_STATUS_COMMENT_SLIP', 'Lieferschein verschickt', " . $gr . ", 180, NULL, now(), NULL, NULL)";
				$config['PDF_FILENAME_SLIP'] = "('PDF_FILENAME_SLIP', 'SomeSlip{oID}', " . $gr . ", 190, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_SUBJECT_SLIP'] = "('PDF_MAIL_SUBJECT_SLIP', 'Ihr Lieferschein', " . $gr . ", 200, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_SLIP_FORWARDER_NAME'] = "('PDF_MAIL_SLIP_FORWARDER_NAME', '', " . $gr . ", 210, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_SLIP_FORWARDER_EMAIL'] = "('PDF_MAIL_SLIP_FORWARDER_EMAIL', '', " . $gr . ", 220, NULL, now(), NULL, NULL)";
				$config['PDF_MAIL_SLIP_FORWARDER'] = "('PDF_MAIL_SLIP_FORWARDER', 'false', " . $gr . ", 222, NULL, now(), NULL, 'xtc_cfg_select_option(array(\'true\', \'false\'),')";
				$config['PDF_MAIL_SLIP_COPY'] = "('PDF_MAIL_SLIP_COPY', '', " . $gr . ", 230, NULL, now(), NULL, NULL)";
				$config['PDF_USE_ORDERID_PREFIX'] = "('PDF_USE_ORDERID_PREFIX', 'RE', " . $gr . ", 240, NULL, now(), NULL, NULL)";
				$config['PDF_BILL_EU_CUSTOMERS_GROUP_ID'] = "('PDF_BILL_EU_CUSTOMERS_GROUP_ID', '4', " . $gr . ", 260, NULL, now(), NULL, NULL)";

				return $config;
			}
		}

	}
?>