<?php
/* -----------------------------------------------------------------------------------------
   $Id: janolaw.php 15854 2024-05-08 12:09:54Z Tomcraft $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com
   (c) 2003   nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org
   (c) 2005 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: janolaw.php 15854 2024-05-08 12:09:54Z Tomcraft $)
   (c) 2008 Gambio OHG (billiger.php 2008-11-11 gambio)

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );

class janolaw {

  var $code;
  var $title;
  var $description;
  var $sort_order;
  var $enabled;
  var $version;
  var $_check;

  function __construct() {
    $this->version = '3.21';
    $this->code = 'janolaw';
    $this->title = MODULE_JANOLAW_TEXT_TITLE;
    $this->description = MODULE_JANOLAW_TEXT_DESCRIPTION;
    $this->enabled = ((defined('MODULE_JANOLAW_STATUS') && MODULE_JANOLAW_STATUS == 'True') ? true : false);
    $this->sort_order = '';
  }

  function process($file) {
    global $messageStack;

    if (defined('TABLE_SCHEDULED_TASKS')
        && isset($_POST['configuration'])
        && isset($_POST['configuration']['MODULE_JANOLAW_STATUS'])
        )
    {
      xtc_db_query("UPDATE ".TABLE_SCHEDULED_TASKS."
                       SET status = '".(($_POST['configuration']['MODULE_JANOLAW_STATUS'] == 'True') ? 1 : 0)."'
                     WHERE tasks = 'janolaw_update'");
    }

    // include needed class
    require_once(DIR_FS_EXTERNAL.'janolaw/janolaw.php');
    
    $error = false;
    $check_array = array(janolaw_content::get_configuration('MODULE_JANOLAW_TYPE_DATASECURITY'),
                         janolaw_content::get_configuration('MODULE_JANOLAW_TYPE_TERMS'),
                         janolaw_content::get_configuration('MODULE_JANOLAW_TYPE_LEGALDETAILS'),
                         janolaw_content::get_configuration('MODULE_JANOLAW_TYPE_REVOCATION'),
                         janolaw_content::get_configuration('MODULE_JANOLAW_TYPE_WITHDRAWAL')
                         );
    $check = array_count_values($check_array);
    foreach ($check as $key => $value) {
      if ($key != '' && $value > 1) {
        $error = true;
        break;
      }
    }
    
    if ($error === true) {
      $messageStack->add_session(MODULE_JANOLAW_ERROR, 'warning');
    } else {    
      $janolaw = new janolaw_content();
    }
  }

  function display() {    
    return array('text' => '<br /><div align="center">' . xtc_button('OK') .
                            xtc_button_link(BUTTON_CANCEL, xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=janolaw')) . "</div>");
  }

  function check() {
    if (!isset($this->_check)) {
      if (defined('MODULE_JANOLAW_STATUS')) {
        $this->_check = true;
      } else {
        $check_query = xtc_db_query("SELECT configuration_value 
                                       FROM " . TABLE_CONFIGURATION . " 
                                      WHERE configuration_key = 'MODULE_JANOLAW_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
    }
    return $this->_check;
  }

  function install() {
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_STATUS', 'False',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_SHOP_ID', '',  '6', '2', '', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_USER_ID', '',  '6', '3', '', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_TYPE', 'Database',  '6', '4', 'xtc_cfg_select_option(array(\'File\', \'Database\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_FORMAT', 'HTML',  '6', '5', 'xtc_cfg_select_option(array(\'HTML\', \'TXT\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_LAST_UPDATED', '',  '6', '7', '', now())");

    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_PDF_DATASECURITY', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_PDF_TERMS', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_PDF_LEGALDETAILS', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_PDF_REVOCATION', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_PDF_WITHDRAWAL', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");

    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_MAIL_DATASECURITY', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_MAIL_TERMS', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_MAIL_LEGALDETAILS', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_MAIL_REVOCATION', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_MAIL_WITHDRAWAL', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_JANOLAW_WITHDRAWAL_COMBINE', 'False',  '6', '8', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");

    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_TYPE_DATASECURITY', '',  '6', '1', 'xtc_cfg_select_content_module(', 'xtc_cfg_display_content', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_TYPE_TERMS', '',  '6', '1', 'xtc_cfg_select_content_module(', 'xtc_cfg_display_content', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_TYPE_LEGALDETAILS', '',  '6', '1', 'xtc_cfg_select_content_module(', 'xtc_cfg_display_content', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_TYPE_REVOCATION', '',  '6', '1', 'xtc_cfg_select_content_module(', 'xtc_cfg_display_content', now())");
    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_TYPE_WITHDRAWAL', '',  '6', '1', 'xtc_cfg_select_content_module(', 'xtc_cfg_display_content', now())");

    xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('MODULE_JANOLAW_UPDATE_INTERVAL', '86400',  '6', '1', 'xtc_cfg_select_interval_module(', 'xtc_cfg_display_interval', now())");

    // check scheduled tasks
    if (defined('TABLE_SCHEDULED_TASKS')) {
      $check_query = xtc_db_query("SELECT *
                                     FROM ".TABLE_SCHEDULED_TASKS."
                                    WHERE tasks = 'janolaw_update'");
      if (xtc_db_num_rows($check_query) < 1) {                      
        xtc_db_query("INSERT INTO " . TABLE_SCHEDULED_TASKS . " (time_regularity, time_unit, status, tasks) VALUES ('1', 'h',  '0', 'janolaw_update')");
      }
    }
  }

  function remove() {
    $database_table = 'content_file';
    if (MODULE_JANOLAW_TYPE == 'Database') {
      $database_table = 'content_text';
    }
    xtc_db_query("UPDATE ".TABLE_CONTENT_MANAGER."
                     SET ".$database_table." = ''
                   WHERE content_group = '".MODULE_JANOLAW_TYPE_DATASECURITY."'");
    xtc_db_query("UPDATE ".TABLE_CONTENT_MANAGER."
                     SET ".$database_table." = ''
                   WHERE content_group = '".MODULE_JANOLAW_TYPE_TERMS."'");
    xtc_db_query("UPDATE ".TABLE_CONTENT_MANAGER."
                     SET ".$database_table." = ''
                   WHERE content_group = '".MODULE_JANOLAW_TYPE_LEGALDETAILS."'");
    xtc_db_query("UPDATE ".TABLE_CONTENT_MANAGER."
                     SET ".$database_table." = ''
                   WHERE content_group = '".MODULE_JANOLAW_TYPE_REVOCATION."'");
    xtc_db_query("UPDATE ".TABLE_CONTENT_MANAGER."
                     SET ".$database_table." = ''
                   WHERE content_group = '".MODULE_JANOLAW_TYPE_WITHDRAWAL."'");

    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_JANOLAW_LAST_UPDATED'");

    // scheduled task
    if (defined('TABLE_SCHEDULED_TASKS')) {
      xtc_db_query("DELETE FROM " . TABLE_SCHEDULED_TASKS . " WHERE tasks = 'janolaw_update'");
    }
  }

  function keys() {
    return array('MODULE_JANOLAW_STATUS',
                 'MODULE_JANOLAW_USER_ID',
                 'MODULE_JANOLAW_SHOP_ID',
                 'MODULE_JANOLAW_TYPE',
                 'MODULE_JANOLAW_FORMAT',

                 'MODULE_JANOLAW_TYPE_DATASECURITY',
                 'MODULE_JANOLAW_PDF_DATASECURITY',
                 'MODULE_JANOLAW_MAIL_DATASECURITY',

                 'MODULE_JANOLAW_TYPE_TERMS',
                 'MODULE_JANOLAW_PDF_TERMS',
                 'MODULE_JANOLAW_MAIL_TERMS',

                 'MODULE_JANOLAW_TYPE_LEGALDETAILS',
                 'MODULE_JANOLAW_PDF_LEGALDETAILS',
                 'MODULE_JANOLAW_MAIL_LEGALDETAILS',

                 'MODULE_JANOLAW_TYPE_REVOCATION',
                 'MODULE_JANOLAW_PDF_REVOCATION',
                 'MODULE_JANOLAW_MAIL_REVOCATION',

                 'MODULE_JANOLAW_TYPE_WITHDRAWAL', 
                 'MODULE_JANOLAW_WITHDRAWAL_COMBINE',                 
                 'MODULE_JANOLAW_PDF_WITHDRAWAL',                 
                 'MODULE_JANOLAW_MAIL_WITHDRAWAL', 
                 
                 'MODULE_JANOLAW_UPDATE_INTERVAL',                
                 );
  }
}
