<?php
  /* -------------------------------------------------------------------------------------
   $Id: account.php 15273 2023-06-27 09:35:15Z GTB $

   modified eCommerce Shopsoftware
   http://www.modified-shop.org

   Copyright (c) 2009 - 2013 [www.modified-shop.org]
   ---------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project (earlier name of osCommerce)
   (c) 2002-2003 osCommerce (account.php,v 1.59 2003/05/19); www.oscommerce.com
   (c) 2003      nextcommerce (account.php,v 1.12 2003/08/17); www.nextcommerce.org
   (c) 2003 XT-Commerce
 
   Released under the GNU General Public License
   ------------------------------------------------------------------------------------ */

include ('includes/application_top.php');

// include needed functions
require_once (DIR_FS_INC.'xtc_count_customer_orders.inc.php');
require_once (DIR_FS_INC.'xtc_get_path.inc.php');
require_once (DIR_FS_INC.'xtc_get_product_path.inc.php');
require_once (DIR_FS_INC.'xtc_get_products_name.inc.php');
require_once (DIR_FS_INC.'xtc_get_products_image.inc.php');
require_once (DIR_FS_INC.'get_tracking_link.inc.php');
require_once (DIR_FS_INC.'xtc_format_price_order.inc.php');
require_once (DIR_FS_INC.'get_order_total.inc.php');
require_once (DIR_FS_INC.'clear_checkout_session.inc.php');

if (!isset($_SESSION['customer_id'])) { 
  xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
} elseif (isset($_SESSION['customer_id']) 
          && $_SESSION['customers_status']['customers_status_id'] == DEFAULT_CUSTOMERS_STATUS_ID_GUEST
          && GUEST_ACCOUNT_EDIT != 'true'
          )
{ 
  xtc_redirect(xtc_href_link(FILENAME_DEFAULT, '', 'SSL'));
}

// create smarty
$smarty = new Smarty();

// clear session
clear_checkout_session();

if ($messageStack->size('account') > 0) {
  $smarty->assign('error_message', $messageStack->output('account'));
}

if ($messageStack->size('account', 'success') > 0) {
  $smarty->assign('success_message', $messageStack->output('account', 'success'));
}

$order_content = array();
$products_history = array();
$also_purchased_history = array();

$max = isset($_SESSION['tracking']['products_history']) ? count($_SESSION['tracking']['products_history']) : 0;
for ($i=0; $i<$max; $i++) {
  $product_history_query = xtDBquery("SELECT p.*,
                                             pd.*,
                                             cd.categories_name 
                                        FROM ".TABLE_PRODUCTS." p
                                        JOIN ".TABLE_PRODUCTS_DESCRIPTION." pd 
                                             ON p.products_id=pd.products_id
                                                AND pd.language_id='".(int) $_SESSION['languages_id']."'
                                        JOIN ".TABLE_PRODUCTS_TO_CATEGORIES." p2c
                                             ON p.products_id = p2c.products_id
                                        JOIN ".TABLE_CATEGORIES_DESCRIPTION." cd
                                             ON cd.categories_id = p2c.categories_id
                                                AND cd.language_id = '".(int) $_SESSION['languages_id']."'
                                       WHERE p.products_status = '1'
                                             ".PRODUCTS_CONDITIONS_P."
                                         AND p.products_id = '".(int) $_SESSION['tracking']['products_history'][$i]."'
                                    GROUP BY p.products_id");
  if (xtc_db_num_rows($product_history_query, true) > 0) {
    $history_product = xtc_db_fetch_array($product_history_query, true);
    $history_product['cat_url'] = xtc_href_link(FILENAME_DEFAULT, 'cPath='.xtc_get_product_path($history_product['products_id']));
    $history_product['categories_name'] = $history_product['categories_name'];
  
    $products_history[] = $product->buildDataArray($history_product);
  }
}
$smarty->assign('products_history', $products_history);

if (xtc_count_customer_orders() > 0) {
  $orders_query = xtc_db_query("SELECT o.*,
                                       os.orders_status_name
                                  FROM ".TABLE_ORDERS." o
                                  JOIN ".TABLE_ORDERS_STATUS." os
                                       ON o.orders_status = os.orders_status_id
                                          AND os.language_id = '".(int) $_SESSION['languages_id']."'
                                 WHERE o.customers_id = '".(int) $_SESSION['customer_id']."'
                              ORDER BY o.orders_id DESC
                                 LIMIT 3");
  $row = 0;
  while ($orders = xtc_db_fetch_array($orders_query)) {
    // count products in order
    $products_query = xtc_db_query("SELECT count(*) as count 
                                      FROM ".TABLE_ORDERS_PRODUCTS." 
                                     WHERE orders_id = '".$orders['orders_id']."'");
    $products = xtc_db_fetch_array($products_query);

    $order_content[$row] = array (
      'ORDER_ID' => $orders['orders_id'], 
      'ORDER_STATUS' => $orders['orders_status_name'], 
      'ORDER_DATE' => xtc_date_short($orders['date_purchased']), 
      'ORDER_PRODUCTS' => $products['count'],
      'ORDER_TOTAL' => xtc_format_price_order(get_order_total($orders['orders_id']), 1, $orders['currency'], 1), 
      'ORDER_LINK' => xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id='.$orders['orders_id'], 'SSL'), 
      'ORDER_BUTTON' => '<a href="'.xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id='.$orders['orders_id'], 'SSL').'">'.xtc_image_button('small_view.gif', SMALL_IMAGE_BUTTON_VIEW).'</a>',
      'ORDER_TRACKING' => get_tracking_link($orders['orders_id'], $_SESSION['language_code']),
      'BUTTON_CART' => '<a href="'.xtc_href_link(FILENAME_ACCOUNT, 'action=add_order&order_id='.$orders['orders_id'], 'SSL').'">'.xtc_image_button('small_cart.gif', IMAGE_BUTTON_IN_CART).'</a>',
    );
    
    // fallback
    $order_content[$row]['TRACKING'] = $order_content[$row]['ORDER_TRACKING'];
    
    if (defined('MODULE_CHECKOUT_EXPRESS_STATUS') && MODULE_CHECKOUT_EXPRESS_STATUS == 'true') {
      $order_content[$row]['BUTTON_CART_EXPRESS'] = '<a href="'.xtc_href_link(FILENAME_ACCOUNT, 'action=add_order&express=on&order_id='.$orders['orders_id'], 'SSL').'">'.xtc_image_button('small_express.gif', IMAGE_BUTTON_IN_CART).'</a>';
    }

    $row ++;
  }
}
$smarty->assign('order_content', $order_content);

if ((isset($_SESSION['customer_id']) && $_SESSION['customers_status']['customers_status_id'] != DEFAULT_CUSTOMERS_STATUS_ID_GUEST)) {
  $smarty->assign('LINK_ORDERS', xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  if (isset($_SESSION['customer_id']) && $_SESSION['customer_id'] != '1') {
    $smarty->assign('LINK_DELETE', xtc_href_link(FILENAME_ACCOUNT_DELETE, '', 'SSL'));
  }
  $smarty->assign('LINK_PASSWORD', xtc_href_link(FILENAME_ACCOUNT_PASSWORD, '', 'SSL'));
  if (defined('MODULE_CHECKOUT_EXPRESS_STATUS') && MODULE_CHECKOUT_EXPRESS_STATUS == 'true') {
    $smarty->assign('LINK_EXPRESS', xtc_href_link(FILENAME_ACCOUNT_CHECKOUT_EXPRESS, '', 'SSL'));
  }
}

if (isset($_SESSION['customer_id'])) {
  $smarty->assign('LINK_ALL', xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));
  $smarty->assign('LINK_EDIT', xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'));
  $smarty->assign('LINK_ADDRESS', xtc_href_link(FILENAME_ADDRESS_BOOK, '', 'SSL'));
} else {
  $smarty->assign('LINK_LOGIN', xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

if (defined('MODULE_NEWSLETTER_STATUS') && MODULE_NEWSLETTER_STATUS == 'true') {
  $smarty->assign('LINK_NEWSLETTER', xtc_href_link(FILENAME_NEWSLETTER, '', 'SSL'));
}

// build breadcrumb
$breadcrumb->add(NAVBAR_TITLE_ACCOUNT, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));

// include header
require (DIR_WS_INCLUDES.'header.php');

// include boxes
$display_mode = 'account';
require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');

$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
$main_content = $smarty->fetch(CURRENT_TEMPLATE.'/module/account.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content', $main_content);
$smarty->caching = 0;
if (!defined('RM'))
  $smarty->load_filter('output', 'note');
$smarty->display(CURRENT_TEMPLATE.'/index.html');
include ('includes/application_bottom.php');